### RDP TABLE GENERATOR MASTER ### 
# This script contains, in order, all the code to generate 
# all the tables for the 2022 CPS RDP.
# Authors: Tanya Livermore, Jack Mulqueeney, Thuong Nguyen, Benjamin Watson
# Date: 14/11/2023

# Load required packages
library(tidyverse)

## Table 1: Consumer Payments Method ##
Table1 <- diary_full %>% 
  filter(paymeth_crosswave != "Missing", paymeth_crosswave !="Transport card", !is.na(paymeth_crosswave), payamt < 9999, payamt >= 0) %>% 
  filter(!(paypurp_crosswave %in% c("Cash deposit", "Transfers to a family member or friend", "Transfer within own accounts"))) %>% 
  group_by(Survey_year, paymethcons3) %>% 
  mutate(counttrans = 1) %>% 
  summarise(number = sum(dweight*counttrans),
            value = sum(payamt*dweight)) %>% 
  group_by(Survey_year) %>% 
  mutate(number = number*100/sum(number),
         value = value*100/sum(value)) %>% 
  pivot_wider(., id_cols = paymethcons3, names_from = Survey_year, values_from = c("number", "value"))


## Table 2: Cash top ups by source ##
p1 <- diary_full %>%
  group_by(Survey_year, Respondent_ID) %>% 
  mutate(topup = ifelse(!(topupsource %in% c(NA, "Missing")), 1, 0)) %>%
  select(Respondent_ID, Survey_year, topupsource, topup, dweight) %>% 
  group_by(Respondent_ID, Survey_year) %>% 
  mutate(n_topups = sum(topup)) %>% 
  mutate(at_least_one = ifelse(n_topups >= 1, 1, 0)) %>% 
  select(-topupsource, -topup, -n_topups) %>% 
  distinct() %>%
  group_by(Survey_year) %>% 
  summarise(share = weighted.mean(at_least_one, w = dweight)*100) %>% 
  mutate(id_col = "Share of respondents making one of more top-ups (%)") %>% 
  pivot_wider(., id_cols = id_col, names_from = Survey_year, values_from = share)



# Average number of cash top-ups per person per week
p2 <- diary_full %>%
  filter(!(topupsource %in% c("Missing", NA))) %>% # Filter out bad entries
  group_by(Respondent_ID) %>% 
  mutate(topup = ifelse(n() > 0, 1, 0)) %>%
  select(Survey_year, Respondent_ID, topup, topupsource, dweight) %>%
  group_by(Survey_year, topupsource) %>%
  count(wt = dweight) %>% # Compute average weekly topups by top up method
  group_by(Survey_year) %>% 
  mutate(total = sum(n)) %>% # Compute average total weekly top ups.
  pivot_wider(., id_cols = Survey_year, names_from = topupsource, values_from = n) %>% 
  mutate(total = ATM + `EFTPOS cash-out` + `Over the counter` + Other) %>% 
  pivot_longer(., cols = names(.)[-1]) %>% 
  pivot_wider(., id_cols = name, names_from = Survey_year, values_from = value) %>% 
  rename(., "id_col" = "name")

# Median value of top ups
p3 <- diary_full %>%
  filter(!(topupsource %in% c("Missing", "NA", NA)), as.numeric(as.character(topupamt)) > 0, !(topupamt %in% c("Missing", "NA"))) %>% # Filter out bad entries, and only positive topups
  select(Survey_year, Respondent_ID, topupamt, topupsource, dweight) %>%
  mutate(topupamt = as.numeric(as.character(topupamt))) %>% # Ensure that R reads the top-up amount as a number, not factor
  group_by(Survey_year, topupsource) %>%
  mutate(newweight = dweight/sum(dweight)) %>% # Create new weights within each subgroup
  arrange(topupamt, .by_group = TRUE) %>% # Arrange from smallest to largest
  mutate(cumsumweight = cumsum(newweight)) %>% # Find the cumulative sum of the newweights
  mutate(medpt = ifelse(cumsumweight > 0.5 & lag(cumsumweight, 1) < 0.5, 1, 0)) %>% # Identify the point where the cumulative sum passes thru 0.5
  filter(medpt == 1) %>% # Select only the medians.
  select(-medpt, -dweight, -newweight, -cumsumweight, -Respondent_ID) %>%
  pivot_wider(., names_from = Survey_year, values_from = topupamt) %>% 
  rbind(., diary_full %>%
          filter(!(topupsource %in% c("Missing", "NA")), as.numeric(as.character(topupamt)) > 0, !(topupamt %in% c("Missing", "NA"))) %>% # Filter out bad entries, and only positive topups
          select(Survey_year, Respondent_ID, topupamt, dweight) %>%
          mutate(topupamt = as.numeric(as.character(topupamt))) %>% # Ensure that R reads the top-up amount as a number, not factor
          group_by(Survey_year) %>%
          mutate(newweight = dweight/sum(dweight)) %>% # Create new weights within each subgroup
          arrange(topupamt, .by_group = TRUE) %>% # Arrange from smallest to largest
          mutate(cumsumweight = cumsum(newweight)) %>% # Find the cumulative sum of the newweights
          mutate(medpt = ifelse(cumsumweight > 0.5 & lag(cumsumweight, 1) < 0.5, 1, 0)) %>% # Identify the point where the cumulative sum passes thru 0.5
          filter(medpt == 1) %>% # Select only the medians.
          select(-medpt, -dweight, -newweight, -cumsumweight, -Respondent_ID) %>%
          pivot_wider(., names_from = Survey_year, values_from = topupamt) %>% 
          mutate(topupsource = "Total")) %>% 
  rename(., "id_col" = "topupsource")

# Share of top-ups attracting a fee
p4 <- diary_full %>% 
  filter(as.numeric(as.character(topupamt)) > 0, Survey_year != 2007, !is.na(topupfee)) %>%
  select(Survey_year, topupfee, dweight) %>%
  mutate(topupfee = as.character(topupfee)) %>%
  group_by(Survey_year) %>% 
  mutate(newweight = dweight/sum(dweight)) %>%
  group_by(Survey_year, topupfee) %>%
  dplyr::count(wt = newweight) %>% 
  group_by(Survey_year) %>%
  mutate(perc = n*100/sum(n)) %>%
  pivot_wider(., id_cols = topupfee, names_from = Survey_year, values_from = perc) %>% 
  rename(., "id_col" = "topupfee") %>% 
  filter(id_col == "Yes") %>% 
  mutate(`2007` = "na")

Table2 <- rbind(p1, p2, p3, p4)

Table2 <- Table2 %>% 
  dplyr::mutate(across(.cols =  as.character(seq(2007, 2022, by = 3)), as.numeric)) %>% 
  dplyr::mutate(across(.cols =  as.character(seq(2007, 2022, by = 3)), ~ round(.x, digits = 1)))


## Table 3: Card Payments for Different Types of Purchases
# Top matter - payment value ($)
Table3_PayVal <- diary_full %>% 
  filter(paymeth_crosswave != "Missing", paymeth_crosswave != "Transport card", payamt >= 0, payamt < 9999, paymethcons3 != "Missing", !is.na(paymeth_crosswave)) %>% # Filter out certain payments
  filter(!(paypurp_crosswave %in% c("Cash deposit","Transfers to family member or friend","Transfer within own accounts"))) %>% 
  group_by(Respondent_ID, paymethcons3, Survey_year, dweight, payamtbinr) %>% # group by Survey_years, and payment method
  count() %>% # count number in each category
  ungroup() %>%
  mutate(weighted_num = n*dweight) %>%  # calculate percentage contribution of each individual
  group_by(paymethcons3, Survey_year, payamtbinr) %>% # group back by Survey_year and payment method
  summarise(total = sum(weighted_num)) %>%
  ungroup() %>% 
  group_by(Survey_year, payamtbinr) %>%
  mutate(total = total*100/sum(total)) %>%
  pivot_wider(., names_from = paymethcons3, values_from = total) %>%
  mutate(Card = Debit + Credit) %>%
  select(Survey_year, payamtbinr, Cash, Card) %>%
  mutate(payamtbinr = parse_number(payamtbinr)) %>% 
  arrange(payamtbinr) %>% 
  pivot_longer(., cols = c("Cash", "Card")) %>% 
  mutate(Survey_year = paste0(Survey_year, "_", name)) %>% 
  pivot_wider(., id_cols = payamtbinr, names_from = Survey_year, values_from = value) %>% 
  rename(., var = payamtbinr) %>%
  mutate(var = as.character(var)) %>% 
  na.omit()

# Bottom matter - broad merchant categories
Table3_MerchCat <- diary_full %>% 
  filter(paymeth_crosswave != "Missing",paymeth_crosswave != "Transport card", payamt >= 0, payamt < 9999, paymethcons3 != "Missing", !is.na(paymeth_crosswave),!is.na(paypurpcons2)) %>% # Filter out certain payments
  filter(!(paypurp_crosswave %in% c("Missing","Cash deposit","Transfers to family member or friend","Transfer within own accounts"))) %>% 
  group_by(Respondent_ID, paymethcons3, Survey_year, dweight, paypurpcons2) %>% # group by Survey_years, and payment method
  count() %>% # count number in each category
  ungroup() %>%
  mutate(weighted_num = n*dweight) %>%  # calculate percentage contribution of each individual
  group_by(paymethcons3, Survey_year, paypurpcons2) %>% # group back by Survey_year and payment method
  summarise(total = sum(weighted_num)) %>%
  ungroup() %>% 
  group_by(Survey_year, paypurpcons2) %>%
  mutate(total = total*100/sum(total)) %>%
  pivot_wider(., names_from = paymethcons3, values_from = total) %>%
  mutate(Card = Debit + Credit) %>%
  select(Survey_year, paypurpcons2, Cash, Card) %>% 
  pivot_longer(., cols = c("Cash", "Card")) %>% 
  mutate(Survey_year = paste0(Survey_year, "_", name)) %>% 
  pivot_wider(., id_cols = paypurpcons2, names_from = Survey_year, values_from = value) %>% 
  rename(., var = paypurpcons2)%>%
  arrange(match(var,c("Supermarket","Food retail","Goods","Transport","Petrol","Leisure","Holiday","Bills","Services","Other")))


Table3 <- rbind(Table3_PayVal, Table3_MerchCat)


# Table 4: Card Surcharges Paid


`%not in%` <- function (x, table) is.na(match(x, table, nomatch=NA_integer_))


#all
Table4_all<-diary_full %>%
  filter(!is.na(payamt),
         !is.na(cardsurch)) %>%
  filter(paymethcons3 %in% c("Debit", "Credit"), 
         as.numeric(payamt) >= 0, as.numeric(payamt) < 9999) %>% 
  filter(paypurp_crosswave %not in% c("Transfers to a family member or friend",
                                      "Transfer within own accounts",
                                      "-1",
                                      NA)) %>%
  group_by(Survey_year, cardsurch) %>% # Group by year and person to create new weights
  count(., wt = dweight) %>%
  group_by(Survey_year) %>%
  mutate(pct = n*100/sum(n))%>%
  filter(cardsurch == "Yes")%>%
  mutate(var="all")


#credit v debit
credit_debit<-diary_full %>%
  filter(!is.na(payamt),
         !is.na(cardsurch)) %>%
  filter(paymethcons3 %in% c("Debit", "Credit"), 
         as.numeric(payamt) >= 0, as.numeric(payamt) < 9999) %>% 
  #filter(is.na(cardsurchamtp)|as.numeric(cardsurchamtp)<=10) %>% 
  filter(paypurp_crosswave %not in% c("Transfers to a family member or friend",
                                      "Transfer within own accounts",
                                      "-1",
                                      NA)) %>%
  group_by(Survey_year, paymethcons3,cardsurch) %>% # Group by year and person to create new weights
  count(., wt = dweight) %>%
  group_by(Survey_year,paymethcons3) %>%
  mutate(pct = n*100/sum(n))%>%
  filter(cardsurch == "Yes")%>%
  rename(var=paymethcons3)



# By reward card
reward<-diary_full %>%
  filter(!is.na(payamt),
         !is.na(cardsurch)) %>%
  filter(paymethcons3 %in% c("Debit", "Credit"), 
         as.numeric(payamt) >= 0, as.numeric(payamt) < 9999) %>% 
  # Filter out certain payments, so that we only look at in-person payments, only look at card payments
  filter(paypurp_crosswave %not in% c("Transfers to a family member or friend",
                                      "Transfer within own accounts",
                                      "-1",
                                      NA)) %>%
  group_by(Survey_year,ccreward,cardsurch) %>% # Group by year and person to create new weights
  count(., wt = dweight) %>%
  group_by(Survey_year,ccreward) %>%
  mutate(pct = n*100/sum(n)) %>%
  filter(ccreward %in% c("Yes","No"),
         cardsurch == "Yes")%>%
  rename(var=ccreward)%>%
  mutate(var=case_when(
    var=="Yes" ~ "Owns rewards card",
    var=="No" ~ "Doesn't own rewards card",
  ))

# By payment channel
by_channel<-diary_full %>%
  filter(!is.na(payamt),
         !is.na(cardsurch),
         !is.na(paychan_crosswave)) %>%
  #(is.na(cardsurchamtp)|cardsurchamtp %not in% c("10","100")) %>% 
  filter(paymethcons3 %in% c("Debit", "Credit"), 
         as.numeric(payamt) >= 0, as.numeric(payamt) < 9999) %>% 
  # Filter out certain payments, so that we only look at in-person payments, only look at card payments
  filter(paypurp_crosswave %not in% c("Transfers to a family member or friend",
                                      "Transfer within own accounts",
                                      "-1",
                                      NA)) %>%
  mutate(inper = case_when(
    paychan_crosswave == "In person" ~ "In person",
    paychanx == "Online" ~ "Online",
    T ~ "Other"))%>%
  group_by(Survey_year, inper,cardsurch) %>% # Group by year and person to create new weights
  count(., wt = weight) %>%
  group_by(Survey_year, inper) %>%
  mutate(pct = n*100/sum(n)) %>%
  filter(cardsurch == "Yes")%>%
  rename(var=inper)

Table4<- rbind(Table4_all,credit_debit,reward,by_channel)%>%filter(Survey_year %in% c("2019","2022"))

Table4<-Table4 %>% 
  select(-n,-cardsurch)%>%
  pivot_wider(id_cols=Survey_year,names_from = var, values_from = pct)


# Table 5 Dual Network Debit Cards

#Clean data
DNDC_data <- merged_data %>%
  filter(idtag_diarycrosswave==1) %>%
  dplyr::mutate(short_pre = case_when(
    dndcown_pre == "I don't know / I'm unsure"~"Unsure",
    dndcown_pre == "I don’t know / I’m unsure"~"Unsure",
    dndcown_pre == "No - I don't have an ATM/debit card that can process payments through more than one network" ~ "No",
    dndcown_pre == "No – I don’t have an ATM/debit card that can process payments through more than one network" ~ "No",
    dndcown_pre == "Yes - I have an ATM/debit card that can process payments through more than one network" ~ "Yes",
    dndcown_pre == "Yes – I have an ATM/debit card that can process payments through more than one network" ~ "Yes"
  ))


#preferred network
DNDC_pref<-  DNDC_data %>% 
  dplyr::mutate(dndcpref = case_when(dndcpref=="Eftpos"~"eftpos",T~dndcpref))%>%
  filter(dcown=="Yes"&!is.na(dndcmatter)) %>%
  count(dndcpref,dcown,wt=dweight) %>%
  dplyr::mutate(freq_all=100*n/sum(n))%>%
  arrange(desc(freq_all))%>%
  dplyr::mutate(n_matters=case_when(is.na(dndcpref) ~ NA, 
                                    T~n))%>%
  dplyr::mutate(freq_matters=100*n_matters/sum(n_matters,na.rm=TRUE))%>%
  rename(var=dndcpref)

#factors that influence choice
DNDC_factors<-  DNDC_data %>% 
  filter(dcown=="Yes"&!is.na(dndcmatter)) %>%
  select(contains("dndcpreffactor"),dweight)%>%
  pivot_longer(!dweight,names_to="factors",values_to="y_n")%>%
  count(factors,y_n,wt=dweight)%>%
  dplyr::mutate(y_n=case_when(	
    factors=="dndcpreffactor_1"&is.na(y_n)~"Keep",
    T~y_n))%>%
  filter(y_n=="Yes"|y_n=="Keep")%>%
  dplyr::mutate(freq_all=100*n/sum(DNDC_pref$n))%>%
  dplyr::mutate(freq_matters=100*n/sum(DNDC_pref$n_matters,na.rm=TRUE))%>%
  rename(var=factors)%>%
  dplyr::mutate(var=case_when(y_n=="Keep" ~ NA,
                              T~var))%>%
  dplyr::mutate(freq_matters=case_when(is.na(var) ~ NA,
                                       T~freq_matters))%>%
  arrange(desc(freq_matters))


#Create one table
Table5<-DNDC_pref%>%select(-dcown,-n,-n_matters)%>%
  rbind(select(DNDC_factors,-y_n,-n))


### Table 6 Online Payments ###

diary_tab6 <- diary_full %>% 
  mutate(paychanx = case_when(
    Survey_year %in% c(2007, 2010) & paychan_crosswave %in% c("Internet (PC/tablet)") ~ "Online",
    Survey_year %in% c(2007, 2010) & !(paychan_crosswave %in% c("Internet (PC/tablet)", NA, "Missing")) ~ "In person",
    T ~ paychanx
  ))

# Table 6 top matter
Table6_top <- diary_tab6 %>% 
  filter(payamt >= 0, payamt < 9999, paymeth_crosswave != "Transport card") %>% # Filter out certain payments
  filter(!(paypurp_crosswave %in% c("Cash deposit","Transfers to a family member or friend","Transfer within own accounts"))) %>% 
  filter(!(paychanx %in% c("Missing", NA))) %>% 
  select(Respondent_ID, Survey_year, dweight, paychan_crosswave, payamtr, paychanx) %>% 
  mutate(counttrans = 1) %>% 
  group_by(Survey_year, paychanx) %>% 
  summarise(number = sum(counttrans*dweight),
            value = sum(payamtr*dweight)) %>% 
  group_by(Survey_year) %>% 
  mutate(number = number*100/sum(number),
         value = value*100/sum(value)) %>% 
  filter(paychanx == "Online") %>% 
  pivot_longer(., cols = c("number", "value")) %>% 
  pivot_wider(., id_cols = name, names_from = Survey_year, values_from = value) %>% 
  mutate(id = "online of consumer payments")

Table6_top_mobshare <- diary_tab6 %>% 
  filter(payamt >= 0, payamt < 9999, paymeth_crosswave != "Transport card") %>% # Filter out certain payments
  filter(!(paypurp_crosswave %in% c("Cash deposit","Transfers to a family member or friend","Transfer within own accounts"))) %>% 
  filter(!(paychanx %in% c("Missing", NA))) %>% 
  filter(paychanx == "Online") %>% 
  group_by(Survey_year, paychan_crosswave) %>% 
  mutate(counttrans = 1) %>% 
  summarise(number = sum(counttrans*dweight)) %>% 
  group_by(Survey_year) %>% 
  mutate(number = number*100/sum(number)) %>% 
  filter(str_detect(paychan_crosswave, "Smartphone")) %>% 
  pivot_wider(., id_cols = paychan_crosswave, names_from = Survey_year, values_from = number) %>% 
  rename(., name = paychan_crosswave) %>% 
  mutate(id = "mob/app of online") %>% 
  mutate(`2007` = 0, `2010` = 0)

## Get total transactions share, by combining automatic payments and consumer payments
auto_payments <- auto_full %>% 
  filter(inweek == "Yes") %>% 
  select(Survey_year, Respondent_ID, autoamt, nweight) %>% 
  mutate(paychanx = "automatic") %>% 
  rename(., payamtr = autoamt)

diary_payments <- diary_tab6 %>% 
  filter(payamtr >= 0, payamtr <= 9999, paymeth_crosswave != "Transport card") %>% # Filter out certain payments
  filter(!(paypurp_crosswave %in% c("Cash deposit","Transfers to a family member or friend","Transfer within own accounts"))) %>% 
  filter(!(paychanx %in% c("Missing", NA))) %>% 
  select(Survey_year, Respondent_ID, payamtr, nweight, paychanx) 


total_spending <- rbind(diary_payments, auto_payments)

# Compute online/auto as share
Table6_bottom <- total_spending %>% 
  mutate(paychanx = ifelse(paychanx %in% c("Online", "automatic"), "online/auto", paychanx)) %>% 
  mutate(counttrans = 1) %>% 
  group_by(Survey_year, paychanx) %>% 
  summarise(number = sum(nweight*counttrans),
            value = sum(nweight*payamtr)) %>% 
  group_by(Survey_year) %>% 
  mutate(number = number*100/sum(number),
         value = value*100/sum(value)) %>% 
  filter(paychanx == "online/auto") %>% 
  pivot_longer(., cols = c("number", "value")) %>% 
  pivot_wider(., id_cols = name, names_from = Survey_year, values_from = value) %>% 
  mutate(id = "online/auto of tot. spending")


Table6 <- rbind(Table6_top, Table6_top_mobshare, Table6_bottom) %>% 
  mutate(across(where(is.double), round)) %>% 
  select(id, name, `2007`, `2010`, `2013`, `2016`, `2019`, `2022`)



### APPENDIX TABLES ###

## Appendix table 2: Total Transactions recorded in the CPS ##
# d2d payments
x1 <- merged_data %>% 
  filter(transtype == "Payment") %>% 
  summarise(row = "Day-to-day payments",
            "Number" = n(),
            "Value ($)"  = sum(payamt))

# transfers and cash deposits
x2 <- merged_data %>% 
  filter((paypurp_crosswave %in% c("Cash deposit", "Transfers to family member or friend", "Transfer within own accounts"))) %>% 
  summarise(row = "Transfers and cash deposits",
            "Number" = n(),
            "Value ($)"  = sum(payamt))

# automatic payments
x3 <- autopay_database %>%
  summarise(row = "Automatic payments",
            "Number" = n(),
            "Value ($)"  = sum(autoamt))

# top-ups
x4 <- merged_data %>% 
  filter(transtype == "Cash top-up (receiving or withdrawing cash)") %>% 
  summarise(row = "Cash top-ups",
            "Number" = n(),
            "Value ($)"  = sum(payamt))

TableA2 <- rbind(x1, x2, x3, x4)


## Appendix Table 4: 2022 CPS Sample Distribution and Mean Weights ##

## Define variables to create table for
weightingVars <- c("agebinweighting", "gender", "region", "hhincq", "ccown")


Conagebin<-xtabs(Respondent_ID~agebinweighting, data=merged_table)
Conagebin[1:6]<-c(0.11*n_respondents, 0.18*n_respondents, 0.18*n_respondents, 
                  0.16*n_respondents, 0.15*n_respondents, 0.22*n_respondents)

Congender<-xtabs(Respondent_ID~gender, data=merged_table)
Congender[1:2]<-c(0.51*n_respondents, 0.49*n_respondents)

Conregion<-xtabs(Respondent_ID~region, data=merged_table)
Conregion[1:2]<-c(0.67*n_respondents, 0.33*n_respondents)

Conhhinc<-xtabs(Respondent_ID~hhincbin, data=merged_table)
Conhhinc[1:4]<-c(0.24*n_respondents, 0.26*n_respondents, 0.26*n_respondents, 0.24*n_respondents)

Conccown<-xtabs(Respondent_ID~ccown, data=merged_table)
Conccown[1:2]<-c(0.48*n_respondents, 0.52*n_respondents)


## Population estimates
populationProps <- data.frame(bracket = c(merged_data$agebinweighting %>% unique(),
                                          merged_data$gender %>% unique(),
                                          merged_data$region %>% unique(),
                                          merged_data$hhincq %>% unique(),
                                          merged_data$ccown %>% unique()),
                              var = c(rep("agebinweighting", 6),
                                      rep("gender", 2),
                                      rep("region", 2),
                                      rep("hhincq", 4),
                                      rep("ccown", 2))) %>% 
  group_by(var) %>% 
  arrange(parse_number(bracket), .by_group = T) %>% 
  ungroup() %>% 
  mutate(pop = c(0.11, 0.18, 0.18, 0.16, 0.15, 0.22, # agebin
                 0.48, 0.52, # ccown
                 0.51, 0.49, # gender
                 0.24, 0.26, 0.26, 0.24, # hhincq
                 0.48, 0.52)) %>% # region
  mutate(pop = 100*pop)
# Compute the sample proportions

sampleProportions <- lapply(weightingVars, function(x){
  merged_data %>% 
    filter(idtag_diarycrosswave == 1) %>% 
    count(eval(parse(text = x))) %>% 
    mutate(perc = round(n*100/sum(n), digits = 0)) %>% 
    select(-n) %>% 
    setNames(c("bracket", "sample")) %>% 
    mutate(var = x)
}) %>% do.call(rbind, .)

sampleWeights <- lapply(weightingVars, function(x){
  merged_data %>% 
    filter(idtag_diarycrosswave == 1) %>% 
    group_by(eval(parse(text = x))) %>% 
    summarise(meanWeight = round(mean(weight), digits = 2)) %>% 
    setNames(c("bracket", "meanweight")) %>% 
    mutate(var = x)
}) %>% do.call(rbind, .)


## Join all together
TableA4 <- left_join(sampleProportions, sampleWeights, by = c("bracket", "var")) %>% 
  left_join(., populationProps, by = c("bracket", "var")) %>% 
  select(var, bracket, sample, pop, meanweight)
